declare('LaunchButton', {}) --because someone was whiny.
local major, minor = 'LaunchButton', 'Key'
local fontcolor = '\127ffffff'
local keycode = gkini.ReadString(major, minor, 'l')
local keymap = {
	['space'] = 'SP',['!'] = 'exclam',['"'] = 'quotedbl',['#'] = 'numbersign',['$'] = 'dollar',['%'] = 'percent',['&'] = 'ampersand',["'"] = 'apostrophe',['('] = 'parentleft',[')'] = 'parentright',['*'] = 'asterisk',['+'] = 'plus',[','] = 'comma',['-'] = 'minus',['.'] = 'period',['/'] = 'slash',['0'] = '0',['1'] = '1',['2'] = '2',['3'] = '3',['4'] = '4',['5'] = '5',['6'] = '6',['7'] = '7',['8'] = '8',['9'] = '9',[':'] = 'colon',[';'] = 'semicolon',['<'] = 'less',['='] = 'equal',['>'] = 'greater',['?'] = 'question',['@'] = 'at',['A'] = 'A',['B'] = 'B',['C'] = 'C',['D'] = 'D',['E'] = 'E',['F'] = 'F',['G'] = 'G',['H'] = 'H',['I'] = 'I',['J'] = 'J',['K'] = 'K',['L'] = 'L',['M'] = 'M',['N'] = 'N',['O'] = 'O',['P'] = 'P',['Q'] = 'Q',['R'] = 'R',['S'] = 'S',['T'] = 'T',['U'] = 'U',['V'] = 'V',['W'] = 'W',['X'] = 'X',['Y'] = 'Y',['Z'] = 'Z',
	['['] = 'bracketleft',['\\'] = 'backslash',[']'] = 'bracketright',['^'] = 'circum',['_'] = 'underscore',['`'] = 'grave',['a'] = 'a',['b'] = 'b',['c'] = 'c',['d'] = 'd',['e'] = 'e',['f'] = 'f',['g'] = 'g',['h'] = 'h',['i'] = 'i',['j'] = 'j',['k'] = 'k',['l'] = 'l',['m'] = 'm',['n'] = 'n',['o'] = 'o',['p'] = 'p',['q'] = 'q',['r'] = 'r',['s'] = 's',['t'] = 't',['u'] = 'u',['v'] = 'v',['w'] = 'w',['x'] = 'x',['y'] = 'y',['z'] = 'z',['{'] = 'braceleft',['|'] = 'bar',['}'] = 'braceright',['~'] = 'tilde',['esc'] = 'ESC',['enter'] = 'CR',['backspace'] = 'BS',['insert'] = 'INS',['del'] = 'DEL',['tab'] = 'TAB',['home'] = 'HOME',['up'] = 'UP',['pgup'] = 'PGUP',['left'] = 'LEFT',['middle'] = 'MIDDLE',['right'] = 'RIGHT',['end'] = 'END',['down'] = 'DOWN',['pgdn'] = 'PGDN',['pause'] = 'PAUSE',['f1'] = 'F1',['f2'] = 'F2',['f3'] = 'F3',['f4'] = 'F4',['f5'] = 'F5',['f6'] = 'F6',['f7'] = 'F7',['f8'] = 'F8',['f9'] = 'F9',['f10'] = 'F10',['f11'] = 'F11',['f12'] = 'F12',
--	['ctrl-'] = {['space'] = 'cSP',['A'] = 'cA',['B'] = 'cB',['C'] = 'cC',['D'] = 'cD',['E'] = 'cE',['F'] = 'cF',['G'] = 'cG',['H'] = 'cH',['I'] = 'cI',['J'] = 'cJ',['K'] = 'cK',['L'] = 'cL',['M'] = 'cM',['N'] = 'cN',['O'] = 'cO',['P'] = 'cP',['Q'] = 'cQ',['R'] = 'cR',['S'] = 'cS',['T'] = 'cT',['U'] = 'cU',['V'] = 'cV',['W'] = 'cW',['X'] = 'cX',['Y'] = 'cY',['Z'] = 'cZ',['tab'] = 'cTAB',['home'] = 'cHOME',['up'] = 'cUP',['pgup'] = 'cPGUP',['left'] = 'cLEFT',['middle'] = 'cMIDDLE',['right'] = 'cRIGHT',['end'] = 'cEND',['down'] = 'cDOWN',['pgdn'] = 'cPGDN',['insert'] = 'cINS',['del'] = 'cDEL',['f1'] = 'cF1',['f2'] = 'cF2',['f3'] = 'cF3',['f4'] = 'cF4',['f5'] = 'cF5',['f6'] = 'cF6',['f7'] = 'cF7',['f8'] = 'cF8',['f9'] = 'cF9',['f10'] = 'cF10',['f11'] = 'cF11',['f12'] = 'cF12',},
--	['shift-'] = {['Space'] = 'sSP',['enter'] = 'sCR',['insert'] = 'sINS',['del'] = 'sDEL',['tab'] = 'sTAB',['home'] = 'sHOME',['up'] = 'sUP',['pgup'] = 'sPGUP',['left'] = 'sLEFT',['right'] = 'sRIGHT',['end'] = 'sEND',['down'] = 'sDOWN',['pgdn'] = 'sPGDN',['f1'] = 'sF1',['f2'] = 'sF2',['f3'] = 'sF3',['f4'] = 'sF4',['f5'] = 'sF5',['f6'] = 'sF6',['f7'] = 'sF7',['f8'] = 'sF8',['f9'] = 'sF9',['f10'] = 'sF10',['f11'] = 'sF11',['f120'] = 'sF12',},
}

local oldstationk_any = StationDialog.k_any
StationDialog.k_any = function(self, ch)
	if (ch == iup['K_'..keycode]) then
		StationLaunchButton:action()
		return iup.CONTINUE
	else
		return oldstationk_any(self, ch)
	end
end

local oldcapshipk_any = CapShipDialog.k_any
CapShipDialog.k_any = function(self, ch)
	if (ch == iup['K_'..keycode]) then
		CapShipLaunchButton:action()
		return iup.CONTINUE
	else
		return oldcapshipk_any(self, ch)
	end
end

RegisterUserCommand('launchbutton', function(_,data)
	if (data == nil) then 
		print(fontcolor..'The launch button is currently bound to "'..keycode..'".')
		return 
	end
	local first, second --= data[1]:match('(%w+%-)([%w%p]+)')
	local key
	if (first ~= nil) then
-- 		first = first:lower()
-- 		if (second:len() == 1) then second = second:upper() 
-- 		elseif (second:len() > 1) then second = second:lower() 
-- 		end
-- 		if (first == 'ctrl-' or first == 'shift-') then key = keymap[first][second] end
	else
		first = data[1]:match('([%w%p]+)')
		if (first:len() > 1) then first = first:lower() end
		if (first ~= nil) then key = keymap[first] end
	end
	if (key ~= nil) then
		keycode = key
		gkini.WriteString(major, minor, keycode)
		print(fontcolor..'The launch button is now bound to "'..data[1]..'"')
	else
		print(fontcolor..'"'..data[1]..'" is not a valid key combination.')
	end
end)

